package beispiel;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * This is the class Student. It represents a Student with a
 * name, birthdate and unique matnr.
 * @author Marion
 * @version 1
 */
public class Student {
    private int matnr;
    private String name;
    private LocalDate birthdate;
    private List<Course> courses;

    /**
     * Creates a new Student object. After the matnr. is set, it cannot be changed later on.
     * Each student must be created with a unique matnr.
     * @param matnr The unique matnr. of the Student
     * @param name The name of the Student
     * @param birthdate The birthdate of the Student
     */
    public Student(int matnr, String name, LocalDate birthdate) {
        this.matnr = matnr;
        this.name = name;
        this.birthdate = birthdate;
        this.courses = new LinkedList<Course>();
    }

    /**
     * Returns the matnr of the Student. Each student has a unique matnr.
     * @return The matnr of the Student
     */
    public int getMatnr() {
        return matnr;
    }

    /**
     * Returns the name of the student as a single String (first and last name)
     * @return The first and last name of the Student a a single String
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the student as a single String (first and last name)
     * @param name The first and last name of the Student a a single String
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Returns the birthdate of the student
     * @return The birthdate of the student
     */
    public LocalDate getBirthdate() {
        return birthdate;
    }

    /**
     * Sets the birthdate of the student
     * @param birthdate The birthdate of the student
     */
    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    /**
     * Adds the Course to the Student's course list
     * @param course The course to add
     */
    public void joinCourse(Course course) {
        courses.add(course);
    }

    /**
     * Removes a Course from the Student's course list
     * @param course The course to leave
     */
    public void leaveCourse(Course course) {
        courses.remove(course);
    }

    /* In IntelliJ kann man z.B. Teile einer Methode extrahieren.
    So kann man Redundanzen vermeiden (hier als Beispiel wurde das
    doppelt verwendete "a+b" extrahiert */

    int uno(){
        int a = 1;
        int b = 2;
        return getAnInt(a, b);
    }

    int duo(int x) {
        int y = 3;
        return getAnInt(x, y);
    }

    private int getAnInt(int a, int b) {
        return a + b;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Student student = (Student) o;
        return matnr == student.matnr;
    }

    @Override
    public int hashCode() {
        return Objects.hash(matnr);
    }
}
