package beispiel;

import java.util.Objects;

/**
 * This is the class Course. It represents a course that a Student can enroll in.
 * Each Course has a unique id, a name and a certain amount of ECTS.
 * @author Marion
 * @version 1
 */
public class Course {
    private int id;
    private String name;
    private int ects;

    /**
     * Creates a new Cousre object. After the id is set, it cannot be changed later on.
     * Each Course must be created with a unique id
     * @param id The unique id of the Course
     * @param name The name of the Course
     * @param ects The amount of ects the Course gives
     */
    public Course(int id, String name, int ects) {
        this.id = id;
        this.name = name;
        this.ects = ects;
    }

    /**
     * Returns the unique id of the Course
     * @return The unique id of the Course
     */
    public int getId() {
        return id;
    }

    /**
     * Returns the name of the Course
     * @return The name of the Course
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the Course
     * @param name The name of the Course
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Returns the ECTS of the Course
     * @return The ECTS of the Course
     */
    public int getEcts() {
        return ects;
    }

    /**
     * Sets the ECTS of the Course
     * @param ects The ECTS of the Course
     */
    public void setEcts(int ects) {
        this.ects = ects;
    }

    /**
     * Checks if the given Object o is equal to this object
     * @param o The Object to compare to this object
     * @return Returns {@code true}, if the given object is a Course object which has the same
     * id as this object, {@code false} otherwise
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Course course = (Course) o;
        return id == course.id;
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

}
