import wsgiref.handlers
import os

from google.appengine.ext import webapp
from google.appengine.ext.webapp import template
from google.appengine.api import users

from Number import Number
from Number import Comment
from Number import Number_Counter

class BasePage(webapp.RequestHandler):
    def show_template(self, template_name, template_vars):
        default_vars = {'lucky_number': Number.create_number(),
                        'user': users.get_current_user(),
                        'login_url': users.create_login_url(self.request.uri)
                        }
        for value in template_vars:
            default_vars[value] = template_vars[value]
        path = os.path.join(os.path.dirname(__file__), 'templates', template_name)
        self.response.out.write(template.render(path, default_vars))

class Index(BasePage):
    def get(self):
        num = Number.create_number()
        vars = {'number': num}
        self.show_template('index.html', vars)

class NumberPage(BasePage):
    def get(self, number):
        number = int(number)
        number = Number.get_by_key_name(Number.create_key(number))
        if number is None:
            self.redirect('/', False)
            return
        vars = { 'number': number,
                 'comments': Comment.gql('WHERE number = :1', number),
                 'others': (Number.create_number(), Number.create_number(), Number.create_number()) 
                }
        self.show_template('number.html', vars)

class PostComment(BasePage):
    def post(self):
        comment_text = self.request.get('comment')
        number = self.request.get('number')
        
        if comment_text is None or number is None:
            self.redirect('/', False)
            return
        
        number = Number.get_by_key_name(Number.create_key(number))
        if number is None:
            self.redirect('/', False)
            return
        
        comment = Comment(number=number)
        comment.author = users.get_current_user()
        comment.text = comment_text
        comment.put()
        
        self.redirect('/number/' + str(number.number), False)
        
class Popular(BasePage):
    def get(self):
        counters = Number_Counter.gql('WHERE counter > 1 ORDER BY counter DESC LIMIT 10')
        vars = { 'counters': counters}
        self.show_template('popular.html', vars)
        
def main():
    application = webapp.WSGIApplication(
        [('/', Index), 
         (r'/number/(.*)', NumberPage),
         ('/postcomment', PostComment),
         ('/popular', Popular)
        ],
        debug=True
    )
    wsgiref.handlers.CGIHandler().run(application)
    
if __name__ == '__main__':
    main()