import random
from datetime import datetime
from google.appengine.ext import db

class Number(db.Model):
    number = db.IntegerProperty(required=True)
    created_at = db.DateTimeProperty()
    
    @staticmethod
    def create_number():
        value = int(random.random() * 4000000000)
        number = Number(key_name=Number.create_key(value), number=value)
        number.created_at = datetime.now()
        print number.created_at
        number.put()
        return number
    
    def formatted(self):
        m = len(str(self.number)) % 3
        integer = str(self.number)
        parts = [integer[:m]]
        parts.extend([integer[m+t:m+t+3] for t in xrange(0, len(integer[m:]), 3)])
        return ','.join(parts)

    
    def get_counter(self):
        counter = Number_Counter.get_by_key_name(Number_Counter.create_key(self), None)
        if counter is None:
            counter = Number_Counter(key_name=Number_Counter.create_key(self))
            counter.number = self
            counter.counter = 0
        return counter
    
    @staticmethod
    def create_key(number):
        return 'number|' + str(number)
    
class Number_Counter(db.Model):
    counter = db.IntegerProperty(default=0)
    number = db.ReferenceProperty(Number)
    
    @staticmethod
    def create_key(number):
        if type(number) is not Number:
            raise Exception('Number_Counter can not be created for ' + type(number).__name__)
            return
        
        return 'numbercounter|' + str(number.number)
    
    def inc(self):
        self.counter += 1
        self.put()
        return self
    
class Comment(db.Model):
    number = db.ReferenceProperty(Number, required=True)
    author = db.UserProperty()
    created_date = db.DateTimeProperty(auto_now_add=True)
    text = db.TextProperty()