import wsgiref.handlers
import os

from google.appengine.ext import webapp
from google.appengine.ext.webapp import template
from google.appengine.ext import db
from google.appengine.api import users

class Wurst(db.Model):
    name = db.StringProperty(required=True)
    length = db.IntegerProperty()
    price = db.FloatProperty()

class BasePage(webapp.RequestHandler):
    def show_template(self, template_name, template_vars):
        path = os.path.join(os.path.dirname(__file__), 'templates', template_name)
        self.response.out.write(template.render(path, template_vars))

class Index(BasePage):
    def get(self):
        wurst = Wurst.all()
        user = users.get_current_user()
        login_url = users.create_login_url('/')
        
        template_vars = {'test': 'foo bar',
                         'wurst': wurst,
                         'user': user,
                         'login_url': login_url}
        self.show_template('index.html', template_vars)
        
class Error(webapp.RequestHandler):
    def get(self):
        self.response.out.write('the page you requested has gone fishing.')
        
class Home(webapp.RequestHandler):
    def get(self, string):
        self.response.out.write('<html><body><p>' + string + '</p></body></html>')

class SaveWurst(BasePage):
    def post(self):
        name = self.request.get('name')
        laenge = int(self.request.get('laenge'))
        
        wurst = Wurst(name=name)
        wurst.length = laenge
        wurst.price = 1.5 * wurst.length
        wurst.put()
        
        self.redirect('/', False)

def main():
    application = webapp.WSGIApplication(
        [('/', Index), ('/savewurst', SaveWurst), (r'.*', Error)],
        debug=True
    )
    wsgiref.handlers.CGIHandler().run(application)
    
if __name__ == '__main__':
    main()