import wsgiref.handlers
import os
from google.appengine.ext import webapp
from google.appengine.ext.webapp import template
from Number import Number

class BasePage(webapp.RequestHandler):
    def show_template(self, template_name, template_vars):
        default_vars = {'lucky_number': Number.create_number() }
        for value in template_vars:
            default_vars[value] = template_vars[value]
        path = os.path.join(os.path.dirname(__file__), 'templates', template_name)
        self.response.out.write(template.render(path, default_vars))

class Index(BasePage):
    def get(self):
        num = Number.create_number()
        vars = {'number': num}
        self.show_template('index.html', vars)

def main():
    application = webapp.WSGIApplication(
        [('/', Index)],
        debug=True
    )
    wsgiref.handlers.CGIHandler().run(application)
    
if __name__ == '__main__':
    main()