import random

from google.appengine.ext import db

class Number(db.Model):
    number = db.IntegerProperty(required=True)
    created_at = db.DateTimeProperty(auto_now_add=True)
    
    @staticmethod
    def create_number():
        number = Number(number=int(random.random() * 4))
        return number
    
    def get_counter(self):
        counter = Number_Counter.get_by_key_name(Number_Counter.create_key(self), None)
        if counter is None:
            counter = Number_Counter(key_name=Number_Counter.create_key(self))
            counter.counter = 0
        return counter
    
class Number_Counter(db.Model):
    counter = db.IntegerProperty(default=0)
    
    @staticmethod
    def create_key(number):
        if type(number) is not Number:
            raise Exception('Number_Counter can not be created for ' + type(number).__name__)
            return
        
        return 'nc' + str(number.number)
    
    def inc(self):
        self.counter += 1
        self.put()
        return self